/***************************************************************************
 *
 * Copyright (c) 2014 Codethink Limited
 *
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ****************************************************************************/

#include <sstream>

#include "CalibrationApplyFromLogicalCoordinateCommand.h"
#include "ICommandExecutor.h"
#include "Log.h"
#include "TouchAreaSubdivision.h"

using namespace LayerManagerCalibration;
using namespace std;

ExecutionResult CalibrationApplyFromLogicalCoordinateCommand::execute(ICommandExecutor* execute)
{
    ExecutionResult result = ExecutionFailed;
    float x1;
    float x2;
    float x3;
    float y1;
    float y2;
    float y3;
    LayerManagerCalibration::InputDeviceConfiguration* config;

    // get device configuration
    InputDeviceConfigurationMap::iterator match =
        execute->getInputDeviceConfigurations()->find(m_deviceName);
    if (match != execute->getInputDeviceConfigurations()->end())
    {
        config = match->second;
        uint width, height;
        coordinate requiredRaw1, requiredRaw2, requiredRaw3;
        coordinate measuredRaw1, measuredRaw2, measuredRaw3;

        execute->getResolution(&width, &height);

        if (   config->getRawCoordinate(m_subdivisionName,
                                        *m_requiredLogical1,
                                        requiredRaw1,
                                        width,
                                        height,
                                        false)
            && config->getRawCoordinate(m_subdivisionName,
                                        *m_requiredLogical2,
                                        requiredRaw2,
                                        width,
                                        height,
                                        false)
            && config->getRawCoordinate(m_subdivisionName,
                                        *m_requiredLogical3,
                                        requiredRaw3,
                                        width,
                                        height,
                                        false)
            && config->getRawCoordinate(m_subdivisionName,
                                        *m_measuredLogical1,
                                        measuredRaw1,
                                        width,
                                        height,
                                        false)
            && config->getRawCoordinate(m_subdivisionName,
                                        *m_measuredLogical2,
                                        measuredRaw2,
                                        width,
                                        height,
                                        false)
            && config->getRawCoordinate(m_subdivisionName,
                                        *m_measuredLogical3,
                                        measuredRaw3,
                                        width,
                                        height,
                                        false))
        {
            bool calResult = Calibration::calculateCoefficients(measuredRaw1,
                                                                measuredRaw2,
                                                                measuredRaw3,
                                                                requiredRaw1,
                                                                requiredRaw2,
                                                                requiredRaw3,
                                                                x1,
                                                                x2,
                                                                x3,
                                                                y1,
                                                                y2,
                                                                y3);
            if (calResult)
            {
                Calibration& calibration = config->getCalibration();
                calibration.getXCoefficientOne()   = x1;
                calibration.getXCoefficientTwo()   = x2;
                calibration.getXCoefficientThree() = x3;
                calibration.getYCoefficientOne()   = y1;
                calibration.getYCoefficientTwo()   = y2;
                calibration.getYCoefficientThree() = y3;

                result = ExecutionSuccess;
            }
        }
    }

    return result;
}

const string CalibrationApplyFromLogicalCoordinateCommand::getString()
{
    stringstream description;
    description << "CalibrationApplyFromLogicalCoordinateCommand("
                << "deviceName=" << m_deviceName
                << ", m_measuredLogical1=(" << m_measuredLogical1->x << ", "
                                        << m_measuredLogical1->y << ")"
                << ", m_measuredLogical2=(" << m_measuredLogical2->x << ", "
                                        << m_measuredLogical2->y << ")"
                << ", m_measuredLogical3=(" << m_measuredLogical3->x << ", "
                                        << m_measuredLogical3->y << ")"
                << ", m_requiredLogical1=(" << m_requiredLogical1->x << ", "
                                        << m_requiredLogical1->y << ")"
                << ", m_requiredLogical2=(" << m_requiredLogical2->x << ", "
                                        << m_requiredLogical2->y << ")"
                << ", m_requiredLogical3=(" << m_requiredLogical3->x << ", "
                                        << m_requiredLogical3->y << ")";
    return description.str();
}
